#ifndef _METHODS_H
#define _METHODS_H

#include <stdlib.h>
#include <stdio.h>
#include <string>
#include <fstream>
#include "Vector.h"
#include "Strcasecmp.h"
#include "Variable.h"
#include "Mod.h"
#include "StringParser.h"

using namespace std;

#define TITLE_LENGTH 80
#define MAX_LENGTH 256
#define COMMAND_LENGTH 1024

int isDigit(char);
void clearBuffer(char);
int inputInteger(void);
void trim(char * str);
char * trimCopy(const char * str);
void append(char str1[1024], const char * str2);
char * strsub(const char * str, int start, int end);
Vector<Mod> * readMods(const char * fileName, const char * category);
Vector<Variable> * readVariables(const char * fileName, const char * category = NULL, bool allowDuplicates = false);
bool isComment(const char * data);
char * parseCategory(const char * data);
Variable * parseVariable(const char * data);
char * getVariableValue(const char * id, const Vector<Variable> * v);

#endif